## sotto i moduli da caricare - se non li avete utilizzate il comando subito sotto commentato 
library("ForestTools")
#install.packages("ForestTools")
library(rgdal)
#install.packages(rgdal)
library(raster)
#install.packages(raster)

## carico DSM e DTM rispettivamente da drone e lidar
## ATTENZIONE, INSERIRE I PERCORSI DEI VOSTRI RASTER
dsm<-raster("C:\\Users\\pirotti\\Downloads\\dsm_drone.tif")
dtm<-raster("C:\\Users\\pirotti\\Downloads\\lidar\\dtm\\124.tif")


dsm<-raster("000124.tif")
dtm<-raster("124.tif")

## riproietto il DTM da un sistema di riferimento (CRS - coordinate reference system) UTM fuso 32 a UTM fuso 33 per renderlo compatibile con il DSM del drone - 
## QUESTO PASSAGGIO NON E' NECESSARIO SE TUTTI E DUE SONO NELLO STESSO CRS
dtm_32633 <- projectRaster(dtm, crs = crs(dsm))
## nota - se volete visualizzare il CRS di un oggetto raster, ad esempio il dsm, lanciate il comando "crs(dsm)"

## ricampiono il DTM appena riproiettato per renderlo identico al DSM e poter fare la sottrazione
dtm_final<-resample(dtm_32633, dsm)
## sottrazione DSM - DTM per ottenere il CHM
chm<-dsm-dtm_final  
## Funzione per la finestra mobile - x=altezza pixel CHM -- vedi :
#    Popescu S.C., Wynne R.H., (2004) – Seeing the trees in the forest:Using lidar and multispectral data fusion with local filtering and variable window size for estimating tree height. Photogrammetric Engineering & Remote Sensing, 70: 589-604.
#    Pirotti, F. et al 2012. Laser Scanner Applications in Forest and Environmental Sciences. Italian Journal of Remote Sensing, 44, 109–123. doi:10.5721/ItJRS20124419)
lin <- function(x){x * 0.05 + 0.6}


## applico funzione
## versione ForestTools 0.1.5
ttops <- TreeTopFinder(CHM = chm, winFun = lin, minHeight = 2)
## versione ForestTools  >= 0.2.0
ttops <- vwf(CHM = chm, winFun = lin, minHeight = 2)
 
# disegno CHM
plot(chm)
# disegno punti
plot(ttops, col = "blue", pch = 20, cex = 0.5, add = TRUE)
# salvo punto come shapefile
writeOGR(obj=ttops, dsn="C:\\Users\\pirotti\\Downloads\\alberi", layer="alberi", driver="ESRI Shapefile") # this is in geographical projection
